/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.lib.model.part;

import dev.engine_room.flywheel.api.model.Mesh;
import dev.engine_room.flywheel.lib.internal.FlwLibLink;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import dev.engine_room.flywheel.lib.model.SimpleQuadMesh;
import dev.engine_room.flywheel.lib.model.part.VertexWriter;
import dev.engine_room.flywheel.lib.util.RendererReloadCache;
import dev.engine_room.flywheel.lib.vertex.PosTexNormalVertexView;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public final class MeshTree {
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private static final class_4587.class_4665 IDENTITY_POSE = new class_4587().method_23760();
    private static final RendererReloadCache<class_5601, MeshTree> CACHE = new RendererReloadCache<class_5601, MeshTree>(MeshTree::convert);
    @Nullable
    private final Mesh mesh;
    private final class_5603 initialPose;
    private final MeshTree[] children;
    private final String[] childNames;

    private MeshTree(@Nullable Mesh mesh, class_5603 initialPose, MeshTree[] children, String[] childNames) {
        this.mesh = mesh;
        this.initialPose = initialPose;
        this.children = children;
        this.childNames = childNames;
    }

    public static MeshTree of(class_5601 layer) {
        return CACHE.get(layer);
    }

    private static MeshTree convert(class_5601 layer) {
        class_5599 entityModels = class_310.method_1551().method_31974();
        class_630 modelPart = entityModels.method_32072(layer);
        return MeshTree.convert(modelPart, THREAD_LOCAL_OBJECTS.get());
    }

    private static MeshTree convert(class_630 modelPart, ThreadLocalObjects objects) {
        Map<String, class_630> modelPartChildren = FlwLibLink.INSTANCE.getModelPartChildren(modelPart);
        Object[] childNames = (String[])modelPartChildren.keySet().toArray(String[]::new);
        Arrays.sort(childNames);
        MeshTree[] children = new MeshTree[childNames.length];
        for (int i = 0; i < childNames.length; ++i) {
            children[i] = MeshTree.convert(modelPartChildren.get(childNames[i]), objects);
        }
        return new MeshTree(MeshTree.compile(modelPart, objects), modelPart.method_41921(), children, (String[])childNames);
    }

    @Nullable
    private static Mesh compile(class_630 modelPart, ThreadLocalObjects objects) {
        if (modelPart.method_32087()) {
            return null;
        }
        VertexWriter vertexWriter = objects.vertexWriter;
        FlwLibLink.INSTANCE.compileModelPart(modelPart, IDENTITY_POSE, vertexWriter, 0xF000F0, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        MemoryBlock data = vertexWriter.copyDataAndReset();
        PosTexNormalVertexView vertexView = new PosTexNormalVertexView();
        vertexView.load(data);
        return new SimpleQuadMesh(vertexView, "source=MeshTree");
    }

    @Nullable
    public Mesh mesh() {
        return this.mesh;
    }

    public class_5603 initialPose() {
        return this.initialPose;
    }

    public int childCount() {
        return this.children.length;
    }

    public MeshTree child(int index) {
        return this.children[index];
    }

    public String childName(int index) {
        return this.childNames[index];
    }

    public int childIndex(String name) {
        return Arrays.binarySearch(this.childNames, name);
    }

    public boolean hasChild(String name) {
        return this.childIndex(name) >= 0;
    }

    @Nullable
    public MeshTree child(String name) {
        int index = this.childIndex(name);
        if (index < 0) {
            return null;
        }
        return this.child(index);
    }

    public MeshTree childOrThrow(String name) {
        MeshTree child = this.child(name);
        if (child == null) {
            throw new NoSuchElementException("Can't find part " + name);
        }
        return child;
    }

    private static class ThreadLocalObjects {
        public final VertexWriter vertexWriter = new VertexWriter();

        private ThreadLocalObjects() {
        }
    }
}

